/*
 * Decompiled with CFR 0.152.
 */
package com.belenus.interpartsserver3;

import com.belenus.dataconnect.DatabaseManager;
import com.belenus.dataconnect.ParameterContainer;
import com.belenus.dataconnect.ResultSetRowContainer;
import com.belenus.dataconnect.Row;
import com.belenus.dataconnect.RowContainer;
import com.belenus.dataconnect.Template;
import com.belenus.interpartsserver3.FileNote;
import com.belenus.interpartsserver3.InterpartsServer;
import com.belenus.interpartsserver3.Note;
import com.belenus.interpartsserver3.NoteStorage;
import com.belenus.util.Configurator;
import javax.servlet.http.HttpServletRequest;

public class DatabaseNoteStorage
implements NoteStorage {
    private DatabaseManager m_databaseManager;
    private String m_noteQueryRetrieve;
    private String m_noteQueryStore;
    private String m_noteQueryRemove;
    private boolean m_noteStoreWithRetrieve;
    private Configurator m_configurator;

    public DatabaseNoteStorage(InterpartsServer interpartsServer) {
        this.m_databaseManager = interpartsServer.getDatabaseManager();
        this.m_noteQueryRetrieve = interpartsServer.m_noteQueryRetrieve;
        this.m_noteQueryStore = interpartsServer.m_noteQueryStore;
        this.m_noteQueryRemove = interpartsServer.m_noteQueryRemove;
        this.m_noteStoreWithRetrieve = interpartsServer.m_noteStoreWithRetrieve;
        this.m_configurator = interpartsServer.m_configurator;
    }

    private Note getNoteFromRowContainer(RowContainer rowContainer) {
        Note note = Note.EMPTY_FILE_NOTE;
        if (!rowContainer.isEmpty()) {
            Row row = rowContainer.nextRow();
            note = new Note(row);
        }
        return note;
    }

    public Note retrieveNote(HttpServletRequest httpServletRequest) {
        ParameterContainer parameterContainer = new ParameterContainer(httpServletRequest, this.m_configurator);
        Template template = new Template(this.m_noteQueryRetrieve, parameterContainer);
        ResultSetRowContainer rowContainer = new ResultSetRowContainer(this.m_databaseManager, template);
        return this.getNoteFromRowContainer(rowContainer);
    }

    public Note storeNote(HttpServletRequest httpServletRequest) {
        ParameterContainer parameterContainer = new ParameterContainer(httpServletRequest, this.m_configurator);
        Template storeTemplate = new Template(this.m_noteQueryStore, parameterContainer);
        ResultSetRowContainer rowContainer = new ResultSetRowContainer(this.m_databaseManager, storeTemplate);
        if (!this.m_noteStoreWithRetrieve) {
            Template retrieveTemplate = new Template(this.m_noteQueryRetrieve, parameterContainer);
            rowContainer = new ResultSetRowContainer(this.m_databaseManager, retrieveTemplate);
        }
        return this.getNoteFromRowContainer(rowContainer);
    }

    public Note removeNote(HttpServletRequest httpServletRequest) {
        ParameterContainer parameterContainer = new ParameterContainer(httpServletRequest, this.m_configurator);
        Template template = new Template(this.m_noteQueryRemove, parameterContainer);
        ResultSetRowContainer rowContainer = new ResultSetRowContainer(this.m_databaseManager, template);
        return this.getNoteFromRowContainer(rowContainer);
    }

    public FileNote getFileNoteByIdNote(String idNote) {
        return null;
    }

    public FileNote getFileNoteByIdObject(String idObject) {
        return null;
    }
}

